#import( class , CDB_Ram )
#import( class , CS_Bayes )

#include "lib.cs"

CS_ADMIN_SCRIPT this = new CS_ADMIN_SCRIPT($_this);

int Main(CAdminRequest pRequest, CAdminResponse pResponse)
{
 
    //CR_COUNT_BAYES 
    CS_Bayes bayes = this->GetDBBayes();
    
    if (bayes == NULL)
        return CONTINUE_SCRIPT;

    CDB_Ram bayes_learn   = bayes->GetDBRam("learn");
    CDB_Ram bayes_neutral = bayes->GetDBRam("neutral");
    CDB_Ram bayes_spam    = bayes->GetDBRam("spam");
    CDB_Ram bayes_ham     = bayes->GetDBRam("ham");
   
    
    if (bayes_learn != NULL && bayes_neutral != NULL && bayes_spam != NULL && bayes_ham != NULL)
   {
    pResponse->Addnew();
    pResponse->SetFieldAt(1, "quarantena_learn");
    pResponse->SetFieldAt(2, this->Format("%d",bayes_learn->GetCount()) );

    pResponse->Addnew();
    pResponse->SetFieldAt(1, "quarantena_spam");
    pResponse->SetFieldAt(2, this->Format("%d",bayes_spam->GetCount()) );

    pResponse->Addnew();
    pResponse->SetFieldAt(1, "quarantena_ham");
    pResponse->SetFieldAt(2, this->Format("%d", bayes_ham->GetCount()) );

    pResponse->Addnew();
    pResponse->SetFieldAt(1, "quarantena_neutral");
    pResponse->SetFieldAt(2, this->Format("%d",bayes_neutral->GetCount()) );

    pResponse->Send(pRequest->GetCmd(),CR_ACK);
   }
   
 return CONTINUE_SCRIPT;

}